#include "GetPoint.js"

function DoAddPointCurves()
{
	moi.ui.beginUIUpdate();
	moi.ui.showUI( 'CurveOptions' );
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'addpoint' );
	moi.ui.bindUIToInput( 'makecorner', 'value', factory.getInput(0) );

	var pointpicker = moi.ui.createPointPicker();
	pointpicker.disableStraightSnap = true;
	pointpicker.disableObjectSnap = true;
	pointpicker.enableOnObjectSnap = true;
	pointpicker.allowMidObjectSnap = true;

	factory.setSnapFunc( pointpicker );

	if ( !GetPoint( pointpicker ) )
		return;
		
	if ( pointpicker.controlDown )
		factory.setInput( 0, true );
		
	factory.update();
	factory.commit();
}

function DoAddPointFace( face )
{
	moi.ui.beginUIUpdate();
	moi.ui.showUI( 'FaceOptions' );
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'addpointsrf' );
	factory.setInput( 0, face );
	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'isodir', 'value', factory.getInput(2) );
	moi.ui.bindUIToInput( 'symmetrical', 'value', factory.getInput(3) );
	factory.disableUpdate( false );
	
	var pointpicker = moi.ui.createPointPicker();
	pointpicker.disableStraightSnap = true;
	pointpicker.disableTanPerpObjectSnap = true;
	pointpicker.enableOnObjectSnap = true;
	pointpicker.resetOnMouseLeave = true;
	pointpicker.restrictToObject( face );
	pointpicker.bindResultPt( factory.getInput(1) );
	
	if ( !GetPoint( pointpicker ) )
		return;
		
	factory.commit();
}

function DoAddPoint()
{
	var objs = moi.geometryDatabase.getSelectedObjects();
	
	if ( objs.numFaces == 1 && objs.length == 1 )
		DoAddPointFace( objs.item(0) );
	else
		DoAddPointCurves();
}

DoAddPoint();
